// patio.cpp  Example for CPS171  Translated to C++ by J.Remen Sept 96
// Updated for Visual C++   Oct 00
// Shows the use of a value-returning function to find the area of a
// triangle, adapted from the FORTRAN 77 version in the book by Page and
// Didday, F77 for Humans.  Note the area of a triangle with sides a,b,c
// is given by Hero's formula i.e. SQRT( s(s-a)(s-b)(s-c) ) where s is
// the semi-perimeter.

#include <iostream>
#include <cmath>
using namespace std;
											// function prototype
float AreaTriangle ( float a, float b, float c);

int main()
											// declare variables
 {  float a, b, c, triangle, patio;
	 patio = 0;
								// Loop to get data until a sentinel of 0 is entered
	 cout << "Enter the three sides of a triangle, use 0's to stop. \n";
	 cin >> a >> b >> c;
	 while (a != 0)
		{   cout << "Sides of this triangle are " << a << ' ' << b
					<< ' ' << c << endl;
								// Use the function to find the area of this triangle
			 triangle = AreaTriangle ( a,b,c);
			 patio = patio + triangle;
									// Get next triangle
			 cout << "Enter next triangle\n";
			 cin >> a >> b >> c;
		}
									// End of loop, print result
	 cout << "\nTotal area of patio is " << patio << endl;

	 return 0;
  }

									// Function definition
float AreaTriangle ( float a, float b, float c)
// This function uses Hero's formula to find the area of a triangle
// with sides a, b and c.
// Pre-condition: a, b and c are defined
// Post-condition: the area of the triangle is returned if the data is
//                 valid, or a 0 if data is invalid

 {									      	// declare local variables
	 float semi;      // holds the semi-perimeter of the triangle
	 float radical;   // the expression for the square root function

	 semi = (a + b + c) /2;
	 radical = semi * (semi - a) * (semi - b) * (semi - c);
											// Check for bad data
	 if (radical < 0)
		{ cout << "Bad data - returning 0 for this triangle\n";
		  return 0.0;
		}
	 else                        // return the area
		  return  sqrt( radical);
 }