
#include <iostream>
#include <cmath>
using namespace std;
#include "point.h"

Point::Point() {
    x_val = y_val = 0;
}

Point::Point(const int x, const int y) {
      x_val = x;
      y_val = y;
}

double Point::distance(Point otherPt) const 
{ 
   return sqrt(double( (x_val - otherPt.x_val) * (x_val - otherPt.x_val) +
                       (y_val - otherPt.y_val) * (y_val - otherPt.y_val) ));
}

Point Point::midpoint(Point otherPt) const
{
     return Point((otherPt.x_val + x_val) / 2,
                  (otherPt.y_val + y_val) / 2 );
}    
    
void Point::print (ostream &out) 
{
      out << "(" << x_val << "," << y_val << ")" << endl;
}
    